/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

function loadComments(url, page) {
    var request = $.ajax({
        url: "ajax.comments.read.php?_LANG=" + $("html").attr("lang") + "&page=" + page,
        type: 'post',
        data: 'url=' + url,
        dataType: 'html'
    });

    request.done(function (msg) {

		var parent = $('#comments-data'),
			content = STBUtils.bgSchemeReplace(msg , parent.attr("data-scheme"));

        parent.html(content);
		parent.attr("data-page" , page);
    });

    request.fail(function (jqXHR, textStatus) {
        alert("Request failed: " + textStatus);
    });
}

function reLoadComments() {
    loadComments($("#comments-data").attr("data-url"), $("#comments-data").attr("data-page"));
}

function reply(e) {
    try {
        e.preventDefault();

        var obj = $(this);
        //remove all the replies from the replies
        $(".comments").find(".comment-new.reply").slideUp(function () {
            $(this).remove();
        });

        var parent = obj.closest(".comment");

        if (obj.hasClass("opened")) {

            obj.removeClass("opened");

            parent.next().slideUp("slow", function () {
                $(this).remove();
            });

        } else {
            obj.addClass("opened");

            var replyform = $("<div class=\"comment-new reply\">" + $(".comment-new.reply").html() + "</div>");

            replyform.find("input[name=parent]").val(parent.attr('data-comment'));
            replyform.find(".reponsebox").empty();

            parent.after(
                replyform
            );

            parent.next().slideDown("slow", function () {
                $(this).find("form-capcha-img").trigger("click");
            });
        }

    } catch (e) {
        getStack(0, e);
    }
}

function onClickReply() {
    try {
        $(document).on('click', '.comment-reply', reply);
    } catch (e) {
        getStack(0, e);
    }
}

$(document).ready(onClickReply);
